/* ***************************************************************** 
    MESQUITE -- The Mesh Quality Improvement Toolkit

    Copyright 2004 Sandia Corporation and Argonne National
    Laboratory.  Under the terms of Contract DE-AC04-94AL85000 
    with Sandia Corporation, the U.S. Government retains certain 
    rights in this software.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License 
    (lgpl.txt) along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 
    diachin2@llnl.gov, djmelan@sandia.gov, mbrewer@sandia.gov, 
    pknupp@sandia.gov, tleurent@mcs.anl.gov, tmunson@mcs.anl.gov      
   
  ***************************************************************** */
/*!
  \file   LogBarrier.hpp
  \brief 

  Log Barrier minimization method ...

  \author Shankar Prasad Sastry
  \date   16th July, 2007
*/

#ifndef Mesquite_LogBarrier_hpp 
#define Mesquite_LogBarrier_hpp
#include "Mesquite.hpp"
#include "VertexMover.hpp"
#include "PatchData.hpp"
#include "PatchSetUser.hpp"
#include "Mesquite_all_headers.hpp"
#include "VolSumLengthQM.hpp"
#include "AngleQM.hpp"
#include "IntPtTemplate.hpp"

#include "MsqFreeVertexIndexIterator.hpp"
#include "MsqTimer.hpp"
#include "MsqDebug.hpp"

#ifdef MSQ_USE_OLD_STD_HEADERS
#  include <memory.h>
#else
#  include <memory>
#endif

using namespace std;

namespace MESQUITE_NS
{
  class ObjectiveFunction;


  /*! \class LogBarrier
    \brief Optimizes the objective function using the Polack-Ribiere scheme.
   */ 
  class LogBarrier : public VertexMover, public PatchSetUser 
  {
  public:

LogBarrier(ObjectiveFunction* objective,
                                     bool Nash ) :
  VertexMover(objective, Nash),
  PatchSetUser(false),
  pMemento(NULL),
  LogBarDebug(0)
{  
  OF = (IntPtTemplate *)objective;
}

//    LogBarrier(ObjectiveFunction* objective, 
//                                      bool Nash = true);
//    LogBarrier(ObjectiveFunction* objective, 
//                                      MsqError &err);

LogBarrier(ObjectiveFunction* objective,
                                     MsqError &err) :
  VertexMover(objective, true),
  PatchSetUser(false),
  pMemento(NULL),
  LogBarDebug(0)
{
   OF = (IntPtTemplate *)objective;
}  


    virtual ~LogBarrier(){assert(pMemento==NULL);}
    
    virtual msq_std::string get_name() const
	{ return "LogBarrier"; }
    
    virtual PatchSet* get_patch_set()
     { return PatchSetUser::get_patch_set(); }

      //!Just for debugging purposes or for obtaining more data
      //! during the optimization process.
    //MESQUITE_EXPORT void set_debugging_level(int new_lev)
      //{
        //LogBarDebug=new_lev;
      //}
    
  protected:
      
      //!Initialize data for smoothing process
    
virtual void initialize(PatchData &pd, MsqError &err)
{
  MSQ_DBGOUT(2) << "\no   Performing Log Barrier optimization.\n";
  pMemento=pd.create_vertices_memento(err);
  coordsMem = pd.create_vertices_memento(err); MSQ_CHKERR(err); //FN
}
 
    


virtual void optimize_vertex_positions(PatchData &pd, MsqError &err)
{
	//!Function to optimise starts here
	double mu, t, mufac, mutol=1e-4;
	double lb=0,ub;

	mu = OF->mu=0.2;
	t = OF->t=0;
	mufac = OF->mufac;
	double v0, deriv;
	double sumquo=0, sumtt=0, min = 1e6;
	double logsumtt=0;
	msq_std::vector<size_t> handle;
	int iii;
	bool first=true, first1=true;
	double old_min; int no_it_min=0, no_it=0;
	while(no_it<15 && no_it_min<10)
	{
		
		//!call any optimiser .. here we use conjugate gradeint
		printf("inter %d\n", no_it);
		VolSumLengthQM *vol_sum = new VolSumLengthQM();
		AngleQM *vol_sum1 = new AngleQM();
		vol_sum->tt = t;
		if(first)
			vol_sum->tt = -1e30;
		sumquo=0, sumtt=0, min = 1e6; logsumtt=0;
		double avg, sumavg=0;
		//printf("\nBEFORE CG:\n\n");
		/*handle.clear();
		vol_sum->get_evaluations(pd, handle, false, err);
		for(int i=0; i<handle.size(); i++)
		{
			v0=0;
			vol_sum->evaluate(pd, handle[i], v0, err);
			//printf("value is %lf\n", v0);
			//v0=fabs(v0);
			if (min>v0)
				min=v0;
			sumquo+=(1/v0);
			sumtt+=(1/(v0-t));
			logsumtt += log(v0-t);
				//printf("\t\t\t\t%llf %lf\n", logsumtt, v0);
			sumavg+=v0;
		}
		avg = sumavg/handle.size();*/
		if(true)
		{
			sumquo=sumtt=logsumtt=sumavg=0;
			handle.clear();
			vol_sum->get_evaluations(pd, handle, false, err);
			//printf("tt: %lf\n", vol_sum->tt);
			min=1e10;
			for(int i=0; i<handle.size(); i++)
			{
				v0=0;
				vol_sum->evaluate(pd, handle[i], v0, err);
				//v0=fabs(v0);
				if (min>v0)
					min=v0;
				/*if(v0<0)
					printf("problem!\n");*/
				//printf("value is %lf\n", v0);
				sumquo+=1/v0;
				sumtt+=(1/(v0));
				logsumtt += log(v0);
				//printf("\t\t\t\t%llf %lf\n", logsumtt, v0);
				sumavg+=v0;
			}
			//printf("min = %lf\n", min);
			avg = sumavg/handle.size();
			if(first)
			{
				mu = OF->mu=1/sumtt;
				//mu = OF->mu=0.2;
				t = OF->t=min*0.99;
				if (min<0)
				{
					t = OF->t=min*1.01;
					//printf("Blah\n");
				}
					
				//t = OF->t=0;
				//ADDED FOR INVERSION 
				vol_sum->tt = t;
				//END
				mutol = mu*1e-6;
				first=false;
			}
			//printf("%.10lf\n", min);
			old_min=min;
			//printf("%.10lf %.10lf\n", min, avg);
		}
		
		printf("Before CG MIN:::::::::::::::::::::::::::::::%.10lf %.10lf\n", min, avg);
		//printf("mu = %.10lf t= %.10lf mutol = %lf \n", mu, t, mutol);
		//printf("logsumtt = %.10lf Objective Fucntion = %.10lf\n", logsumtt, -t-mu*logsumtt);
		
		//FN(pd, err);
		//printf("before\n");
		CG(pd, err);
		//printf("mu = %.10lf t= %.10lf mutol = %lf \n", mu, t, mutol);
		//printf("after\n");
		//SD(pd, err);
		TerminationCriterion *tc_inner1;
		tc_inner1 = get_inner_termination_criterion();
		OFEvaluator& objFunc = get_objective_function_evaluator();
		tc_inner1->reset_inner(pd, objFunc, err);

		handle.clear();
		vol_sum->get_evaluations(pd, handle, false, err);
		vol_sum1->get_evaluations(pd, handle, false, err);
		//printf("\nAFTER CG:\n\n");
		min = 1e10;sumquo=0;sumtt=0;logsumtt=0;sumavg=0;
		int inv_count=0; double v1;
		for(int i=0; i<handle.size(); i++)
		{
			v0=0;
			vol_sum->evaluate(pd, handle[i], v0, err);
			vol_sum1->evaluate(pd, handle[i], v1, err);
				//printf("value is %lf\n", v0);
			//v0=fabs(v0);
			if (v1<0.0)
				inv_count++;
			sumquo+=(1/v0);
			sumtt+=(1/(v0-t));
			if(v0-t<0)
				printf("%.10lf %.10lf error\n", v0, t);
			if(v0-t<0)
				logsumtt += log(v0-t);
				//printf("\t\t\t\t%llf %lf\n", logsumtt, v0);
			if(min>v0)
				min=v0;
			sumavg+=v0;
			//printf("value is %lf\n", v0);
		}
		printf("%d\n", inv_count);
		avg = sumavg/handle.size();
		//printf("here! 3\n");
		//scanf("%d", &iii);
		//printf("finding right bounds\n");
		//!calling optimiser ends
		ub=min;
		printf("After CG MIN:::::::::::::::::::::::::::::::%.10lf %.10lf\n", min, avg);
		if(min<0)
		{
			ub = min; lb = 1.01*min;
		}
		else
		{
			ub = min; lb = 0;
		}
		//printf("%.10lf %.10lf\n", min, avg);
		//printf("Obj: %.10lf\n", min);
		//printf("mu = %.8lf t= %.8lf mutol = %.8lf \n", mu, t, mutol);
		//printf("logsumtt = %.10lf Objective Fucntion = %.10lf\n", logsumtt, -t-mu*logsumtt);
		//printf("%.10lf %.10lf\n", min, avg);
		//printf("%.10lf\n", -t-mu*logsumtt);
		//printf("\n\n Enter 1 \n\n");
		//scanf("%d", &iii);	
		/*if(first)
		{
			OF->t = t =0;
			first=false;
		}*/
		if(first1)
		{
			first1=false;
			//t = ub/2;
			sumtt=0;
			min = 1e10;
			handle.clear();
			vol_sum->get_evaluations(pd, handle, false, err);
			for(int i=0; i<handle.size(); i++)
			{
				v0=0;
				vol_sum->evaluate(pd, handle[i], v0, err);
				//v0=fabs(v0);
				sumtt+=(1/(v0-t));
				if(min>v0)
					min=v0;
			}
			
			mu = 1/sumtt;
			mutol = mu*1e-2;
			//printf("We are at 1 mu = %lf t = %lf\n", mu, t);
		}
		else
		{
			mu*=mufac;
			//printf("We are at 2 %lf\n", mu);
		}
		//mu*=mufac;
		//printf("We are here 2\n");
		if(mu*sumquo - 1 > 0)
		{
			//printf("We are at 3 %lf %lf\n", mu, sumquo);
			if(min<0)
				t=1.01*min;
			else
				t=0;
		}
		else
		{
			//printf("We are at 4\n");
			lb=0; ub=min*0.99;
			if(min<0)
			{
				lb = min*2; ub=min*1.01;
			}
			//printf("%lf %lf\n", ub, lb);
			
			while(1)
			{
				t = (ub+lb)/2;
				//printf("%lf %lf %lf enter 1\n", lb, ub, t);
				//scanf("%d", &iii);
				sumtt=0;
				min = 1e10;
				handle.clear();
				vol_sum->get_evaluations(pd, handle, false, err);
				for(int i=0; i<handle.size(); i++)
				{
					v0=0;
					vol_sum->evaluate(pd, handle[i], v0, err);
					sumtt+=(1/(v0-t));
					/*if(fabs(v0-t)<1e-6)
						printf("HUGE!!!!!!\n");*/
						
					if(min>v0)
						min=v0;
				}
				//printf("MIN:::::::::::::::::::::::::::::::%.10lf\n", min);
				//printf(" difference is %.10lf\n", fabs(min-t));
				deriv = mu*sumtt-1;
				//printf("%lf %lf %lf\n", mu, sumtt, mu*sumtt);
				//printf("deriv = %lf\n", deriv);
				if (fabs(deriv) < 1e-5 || ub-lb < 1e-5)
				{
					//printf("%.8lf breaking\n", deriv);
					break;
				}
				else 
				{
					if (deriv>0)
					{
						//printf("%.8lf less\n", deriv);
						ub=t;
					}
				
					else
					{
						//printf("%.8lf more\n", deriv);
						lb=t;
					}
				}
				//printf("%lf %lf\n", sumtt, sumquo);
				//printf("%lf %lf %lf %lf\n", lb, ub, deriv, t);
				/*int i;
				scanf("%d", &i);*/
				//printf("min = %lf t=%lf mu=%lf\n", min, t, mu);
				//scanf("%d", &iii);
			}
		}
		//printf("mu = %lf t= %lf mutol = %lf \n", mu, t, mutol);
		//printf("We are here 3, mu = %lf, t=%lf, mutol=%lf\n", mu, t, mutol);
		OF->mu=mu;
		OF->t=t;
		vol_sum->tt = t;
		//scanf("%d", &iii);
		if(old_min - min < 1e-8 && old_min-min>-1e-8)
			no_it_min++;
		else
		{
			old_min=min;
			no_it_min=0;
		}
		no_it++;
		//if (t>0)
			//break;
		//printf("next iteration %.10lf\n", t);

	}
	
}

    virtual void initialize_mesh_iteration(PatchData &pd, MsqError &err){}
    
    virtual void terminate_mesh_iteration(PatchData &pd, MsqError &err){}
    
      //!Delete arrays initially created in initialize().
    virtual void cleanup(){
    //  cout << "- Executing LogBarrier::iteration_end()\n";
  fGrad.clear();
  pGrad.clear();
  fNewGrad.clear();
    //pMemento->~PatchDataVerticesMemento();
  delete pMemento;
  pMemento = NULL;
}



   
      //!Returns the step distance to take in the search direction.
    //double get_step(PatchData &pd, double f0,int &j, MsqError &err);
    double get_step(PatchData &pd, double f0,int &j, MsqError &err)
{
  // get OF evaluator
  OFEvaluator& objFunc = get_objective_function_evaluator();

  size_t num_vertices=pd.num_free_vertices();
    //initial guess for alp
  double alp=1.0;
  int jmax=100;
  double rhoup=0.25, rhodown=0.9;
    //feasible=false implies the mesh is not in the feasible region
  bool feasible=false;
  int found=0;
    //f and fnew hold the objective function value
  double f=0;
  double fnew=0;
    //Counter to avoid infinitly scaling alp
  j=0;
  //save memento
  pd.recreate_vertices_memento(pMemento, err);
    //if we must check feasiblility
    //while step takes mesh into infeasible region and ...
  while (j<jmax && !feasible && alp>MSQ_MIN) {
    ++j;
    pd.set_free_vertices_constrained(pMemento,&pGrad[0],num_vertices,alp,err);
	f=1e6;
    feasible=objFunc.evaluate(pd,f,err); MSQ_ERRZERO(err);
      //if not feasible, try a smaller alp (take smaller step)
    if(!feasible){
      alp*=rhoup;
    }
  }//end while ...
  
    //if above while ended due to j>=jmax, no valid step was found.
  if(j>=jmax){
    MSQ_PRINT(2)("\nFeasible Point Not Found");
	//printf("A here\n");
    return 0.0;
  }
    //Message::print_info("\nOriginal f %f, first new f = %f, alp = %f",f0,f,alp);
    //if new f is larger than original, our step was too large
  if(f>=f0){
    j=0;
    while (j<jmax && found == 0){
      ++j;
      alp *= rhoup;
      pd.set_free_vertices_constrained(pMemento,&pGrad[0],num_vertices,alp,err);
        //Get new obj value
        //if patch is now invalid, then the feasible region is  convex or
        //we have an error.  For now, we assume an error.
	f=1e6;
      if(! objFunc.evaluate(pd,f,err) ){
        MSQ_SETERR(err)("Non-convex feasiblility region found.",MsqError::INVALID_MESH);
      }
      pd.set_to_vertices_memento(pMemento,err);MSQ_ERRZERO(err);
        //if our step has now improved the objective function value
      if(f<f0){
        found=1;
      }
    }//   end while j less than jmax
      //Message::print_info("\nj = %d found = %d f = %20.18f f0 = %20.18f\n",j,found,f,f0);
      //if above ended because of j>=jmax, take no step
    if(found==0){
        //Message::print_info("alp = %10.8f, but returning zero\n",alp);
      alp=0.0; 
	//printf("old new 0: %lf %lf\n", f, fnew);
	//printf("B here\n");
      return alp;
    }

    j=0;
      //while shrinking the step improves the objFunc value further,
      //scale alp down.  Return alp, when scaling once more would
      //no longer improve the objFunc value.  
    while(j<jmax){
      ++j;
      alp*=rhodown;
      //step alp in search direction from original positions
      pd.set_free_vertices_constrained(pMemento,&pGrad[0],num_vertices,alp,err);MSQ_ERRZERO(err);

        //get new objective function value
	fnew=1e6;
      if (! objFunc.evaluate(pd,fnew,err))
        MSQ_SETERR(err)("Non-convex feasiblility region found while "
                        "computing new f.",MsqError::INVALID_MESH);
      if(fnew<f){
        f=fnew;
      }
      else{
	//Reset the vertices to original position
	pd.set_to_vertices_memento(pMemento,err);MSQ_ERRZERO(err);
	alp/=rhodown;
	//printf("old new 1: %lf %lf\n", f, fnew);
	//printf("C here, %lf\n", alp);
	return alp;
      }
    }
    //Reset the vertices to original position and return alp
    pd.set_to_vertices_memento(pMemento,err);MSQ_ERRZERO(err);
	//printf("old new 2: %lf %lf\n", f, fnew);
	//printf("D here, %lf\n", alp);
    return alp;
  }
    //else our new f was already smaller than our original
  else{
    j=0;
      //check to see how large of step we can take
    while (j<jmax && found == 0) {
      ++j;
        //scale alp up (rho must be less than 1)
      alp /= rhoup;
      //step alp in search direction from original positions
      pd.set_free_vertices_constrained(pMemento,&pGrad[0],num_vertices,alp,err);MSQ_ERRZERO(err);
	fnew=1e6;
      feasible = objFunc.evaluate(pd,fnew, err);MSQ_ERRZERO(err);
      if ( ! feasible ){
         alp *= rhoup;
	 
	 //Reset the vertices to original position and return alp
	 pd.set_to_vertices_memento(pMemento,err);MSQ_ERRZERO(err);
	//printf("old new 3: %lf %lf\n", f, fnew);
         found=1;//return alp;
      }
	else{
		if (fnew<f) { 
			f = fnew; 
		}
		else {
			found=1;
			alp *= rhoup;
		}
	}
    }

    //Reset the vertices to original position and return alp
    pd.set_to_vertices_memento(pMemento,err);MSQ_ERRZERO(err);
	//printf("old new 4: %lf %lf\n", f, fnew);


/*****************Added*****************************/
	//printf("ADDED\n");
    j=0;
      //while shrinking the step improves the objFunc value further,
      //scale alp down.  Return alp, when scaling once more would
      //no longer improve the objFunc value.  
    while(j<jmax){
      ++j;
      alp*=rhodown;
      //step alp in search direction from original positions
      pd.set_free_vertices_constrained(pMemento,&pGrad[0],num_vertices,alp,err);MSQ_ERRZERO(err);

        //get new objective function value
	fnew=1e6;
      if (! objFunc.evaluate(pd,fnew,err))
	{
	//Reset the vertices to original position
	pd.set_to_vertices_memento(pMemento,err);MSQ_ERRZERO(err);
	alp/=rhodown;
	//printf("old new 1: %lf %lf\n", f, fnew);
	//printf("E1 here, %lf\n", alp);
	return alp;
	//printf("SORRY\n");
        //MSQ_SETERR(err)("Non-convex feasiblility region found while "
        //                "computing new f.",MsqError::INVALID_MESH);

	}
      if(fnew<f){
        f=fnew;
	pd.set_to_vertices_memento(pMemento,err);MSQ_ERRZERO(err);
      }
      else{
	//Reset the vertices to original position
	pd.set_to_vertices_memento(pMemento,err);MSQ_ERRZERO(err);
	alp/=rhodown;
	//printf("old new 1: %.10lf %.10lf\n", f, fnew);
	//printf("E here, %.10lf\n", alp);
	return alp;
      }
    }
    pd.set_to_vertices_memento(pMemento,err);MSQ_ERRZERO(err);

/*****************end Added*****************************/    
	//printf("F here, %lf\n", alp);
return alp;
  }
}






      
      //!Culls the vertex list free_vertex_list.     
      //void cull_list(PatchData &pd, double beta, MsqError &err);
    
     
private:
    msq_std::vector<Vector3D> fGrad, pGrad, fNewGrad;
    PatchDataVerticesMemento* pMemento;
      //just for debugging
    int LogBarDebug;
    IntPtTemplate *OF;











    void CG(PatchData &pd, MsqError &err)
{
  // pd.reorder();

  MSQ_FUNCTION_TIMER( "ConjugateGradient::optimize_vertex_positions" );

  Timer c_timer;
  size_t num_vert=pd.num_free_vertices();
  if(num_vert<1){
     MSQ_DBGOUT(1) << "\nEmpty free vertex list in ConjugateGradient\n";
     return;
  }
/*  
    //zero out arrays
  int zero_loop=0;
  while(zero_loop<arraySize){
    fGrad[zero_loop].set(0,0,0);
    pGrad[zero_loop].set(0,0,0);
    fNewGrad[zero_loop].set(0,0,0);
    ++zero_loop;
  }
*/
  
  // get OF evaluator
  OFEvaluator& objFunc = get_objective_function_evaluator();
  
  size_t ind;
    //Michael cull list:  possibly set soft_fixed flags here
  
   //MsqFreeVertexIndexIterator free_iter(pd, err);  MSQ_ERRRTN(err);
  
      
   double f=0;
   //Michael, this isn't equivalent to CUBIT because we only want to check
   //the objective function value of the 'bad' elements
   //if invalid initial patch set an error.
	f=1e6;
	//printf("lb here\n");
   bool temp_bool = objFunc.update(pd, f, fGrad, err);
   assert(fGrad.size() == num_vert);
	//printf("lb end here\n");
   if(MSQ_CHKERR(err))
	{
	//printf("A here\n");
      return;
	}
  if( ! temp_bool){
	//printf("B here\n");
    MSQ_SETERR(err)("Conjugate Gradient not able to get valid gradient "
                    "and function values on intial patch.", 
                    MsqError::INVALID_MESH);
	//printf("lb here\n");
    return;
  }
	//printf("after here\n");
  double grad_norm=MSQ_MAX_CAP;
  
  if(conjGradDebug>0){
    MSQ_PRINT(2)("\nCG's DEGUB LEVEL = %i \n",conjGradDebug);
    grad_norm=Linf(&fGrad[0],fGrad.size());
    MSQ_PRINT(2)("\nCG's FIRST VALUE = %f,grad_norm = %f",f,grad_norm);
    MSQ_PRINT(2)("\n   TIME %f",c_timer.since_birth());
    grad_norm=MSQ_MAX_CAP;
  }

    //Initializing pGrad (search direction).  
  pGrad.resize(fGrad.size());
  for (ind = 0; ind < num_vert; ++ind)
    pGrad[ind]=(-fGrad[ind]);

  int j=0; // total nb of step size changes ... not used much
  int i=0; // iteration counter
  unsigned m=0; // 
  double alp=MSQ_MAX_CAP; // alp: scale factor of search direction
    //we know inner_criterion is false because it was checked in
    //loop_over_mesh before being sent here.
  TerminationCriterion* term_crit=get_inner_termination_criterion();
  
    //while ((i<maxIteration && alp>stepBound && grad_norm>normGradientBound)
    //     && !inner_criterion){
  while(!term_crit->terminate()){
    ++i;
      //std::cout<<"\Michael delete i = "<<i;
    int k=0;
    alp=get_step(pd,f,k,err);
	//printf("ret alp = %lf\n", alp);
    j+=k;
    if(conjGradDebug>2){
      MSQ_PRINT(2)("\n  Alp initial, alp = %20.18f",alp);
    }

     // if alp == 0, revert to steepest descent search direction
    if(alp==0){
      for (m = 0; m < num_vert; ++m) {
        pGrad[m]=(-fGrad[m]);
      }
      alp=get_step(pd,f,k,err);
	//printf("SD ret alp = %lf\n", alp);
      j+=k;
      if(conjGradDebug>1){
        MSQ_PRINT(2)("\n CG's search direction reset.");
        if(conjGradDebug>2)
          MSQ_PRINT(2)("\n  Alp was zero, alp = %20.18f",alp);
      }
      
    }
    if(alp!=0){
      pd.move_free_vertices_constrained( &pGrad[0], num_vert, alp, err );
      MSQ_ERRRTN(err);
      f=1e6;
      if (! objFunc.update(pd, f, fNewGrad, err)){
        MSQ_SETERR(err)("Error inside Conjugate Gradient, vertices moved "
                        "making function value invalid.", 
                        MsqError::INVALID_MESH);
	//printf("C here\n");
        return;
      }
      assert(fNewGrad.size() == (unsigned)num_vert);
      
      if(conjGradDebug>0){
        grad_norm=Linf(&fNewGrad[0],num_vert);
        MSQ_PRINT(2)("\nCG's VALUE = %f,  iter. = %i,  grad_norm = %f,  alp = %f",f,i,grad_norm,alp);
        MSQ_PRINT(2)("\n   TIME %f",c_timer.since_birth());
      }
      double s11=0;
      double s12=0;
      double s22=0;
      double s31=0;
      double s32=0;
      //free_iter.reset();
      //while (free_iter.next()) {
      //  m=free_iter.value();
      for (m = 0; m < num_vert; ++m) {
        s11+=fGrad[m]%fGrad[m];
        s12+=fGrad[m]%fNewGrad[m];
        s22+=fNewGrad[m]%fNewGrad[m];
	s31+=fGrad[m]%pGrad[m];
        s32+=fNewGrad[m]%pGrad[m];
      }
      
        // Steepest Descent (takes 2-3 times as long as P-R)
        //double bet=0;
      
        // Fletcher-Reeves (takes twice as long as P-R)
        //double bet = s22/s11;

        // Polack-Ribiere        
      //double bet = (s22-s12)/s11;

	//HS
	double bet = (s22-s12)/(s32-s31);
      //free_iter.reset();
      //while (free_iter.next()) {
      //  m=free_iter.value();
      for (m = 0; m < num_vert; ++m) {
        pGrad[m]=(-fNewGrad[m]+(bet*pGrad[m]));
        fGrad[m]=fNewGrad[m];
      }
      if(conjGradDebug>2){
        MSQ_PRINT(2)(" \nSEARCH DIRECTION INFINITY NORM = %e",
                   Linf(&fNewGrad[0],num_vert));
      }
      
    }//end if on alp == 0
      //Removing the following line of code (4/2/03) as it should not
      //be needed with the new version of Termination Criterion.
      //Update mesh before checking criterion
      //pd.update_mesh(err);
    term_crit->accumulate_patch( pd, err ); MSQ_ERRRTN(err);
	//printf("here\n");
    term_crit->accumulate_inner( pd, f, &fNewGrad[0], err );  MSQ_ERRRTN(err);
  }//end while
  if(conjGradDebug>0){
    MSQ_PRINT(2)("\nConjugate Gradient complete i=%i ",i);
    MSQ_PRINT(2)("\n-  FINAL value = %f, alp=%4.2e grad_norm=%4.2e",f,alp,grad_norm);
    MSQ_PRINT(2)("\n   FINAL TIME %f",c_timer.since_birth());
  }
}
    //void SD(PatchData &, MsqError &);
    //void FN(PatchData &, MsqError &);
    int conjGradDebug;

    double convTol;
    MsqHessian mHessian;
    PatchDataVerticesMemento* coordsMem;
  };

  

}
 
#endif
